//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <Grids.hpp>
#include <Math.h>

#include "Main.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TForm1 *Form1;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
   GSelected = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::imgKONIECClick(TObject *Sender)
{
	Koniec();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Koniec()
{
	if(Application->MessageBoxA("Koniec pracy",
                               "Uwaga",
                               MB_YESNO | MB_ICONEXCLAMATION) == IDYES)
   {
      Application->Terminate();
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Buduj_sg()
{
   int wiersz = 0;

	sg->DefaultRowHeight = 19;

   sg->ColCount = COLS;
   wiersz = 0;

	// SZEROKO KOLUMN
   sg->ColWidths[ 0] =  50;     // Lp
   sg->ColWidths[ 1] =  50;     // Nazwisko
   sg->ColWidths[ 2] =  50;     // Imie
   sg->ColWidths[ 3] =  50;     // Ulica i nr
   sg->ColWidths[ 4] =  50;     // Kod p
   sg->ColWidths[ 5] =  50;     // Miejscowosc
   sg->ColWidths[ 6] =  50;     // Data ur
   sg->ColWidths[ 7] =  50;     // Pesel
   sg->ColWidths[ 8] =  50;     // Telefon
   sg->ColWidths[ 9] =  50;     // E-mail
   sg->ColWidths[10] =  50;     // Wojewdztwo
   sg->ColWidths[11] =  50;     // Zarobek

   // NAGWKI KOLUMN
   sg->Cells[ 0][wiersz] = "Lp";
   sg->Cells[ 1][wiersz] = "Nazwisko";
   sg->Cells[ 2][wiersz] = "Imi";
   sg->Cells[ 3][wiersz] = "Ulica";
   sg->Cells[ 4][wiersz] = "Kod.p";
   sg->Cells[ 5][wiersz] = "Miejsc.";
   sg->Cells[ 6][wiersz] = "Data ur";
   sg->Cells[ 7][wiersz] = "Pesel";
   sg->Cells[ 8][wiersz] = "Telefon";
   sg->Cells[ 9][wiersz] = "E-mail";
   sg->Cells[10][wiersz] = "Woj.";
   sg->Cells[11][wiersz] = "Zarobek";
   ++wiersz;

   int lp = 0;
   for(lp = 200; lp >= 1; lp--)
   {
	   sg->Cells[ 0][wiersz] = IntToStr(lp);
	   sg->Cells[ 1][wiersz] = IntToStr(lp);
	   sg->Cells[ 2][wiersz] = IntToStr(lp);
	   sg->Cells[ 3][wiersz] = IntToStr(lp);
	   sg->Cells[ 4][wiersz] = IntToStr(lp);
	   sg->Cells[ 5][wiersz] = IntToStr(lp);
   	sg->Cells[ 6][wiersz] = IntToStr(lp);
	   sg->Cells[ 7][wiersz] = IntToStr(lp);
	   sg->Cells[ 8][wiersz] = IntToStr(lp);
	   sg->Cells[ 9][wiersz] = IntToStr(lp);
	   sg->Cells[10][wiersz] = IntToStr(lp);
	   sg->Cells[11][wiersz] = IntToStr(lp);
      ++wiersz;
      sg->RowCount = sg->RowCount + 1;
   }

	sg->RowCount = wiersz;
   // nie chc pustego wiersza na kocu
   // sg->RowCount = sg->RowCount + 1;

   sg->FixedCols = 1;
   sg->FixedRows = 1;


   // wczenie opcji
	sg->Options = sg->Options << goFixedVertLine    <<
                                goFixedHorzLine    <<
                                goVertLine         <<
                                goHorzLine         <<
                                goRangeSelect      <<
                                goRowSizing        <<
                                goColSizing        <<
                                goRowMoving        <<
                                goEditing          <<
										  goAlwaysShowEditor <<
                                goColMoving;

   // wyczenie wybranych opcji
   sg->Options = sg->Options >> goAlwaysShowEditor;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
	Buduj_sg();
	sg->Align = alClient;
	
   sg->Col = 1;
   sg->Row = 1;
   sg->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Przypisz_lp()
{
   int ACol          = 0;
 	int ARow          = 0;
   int ilosc_wierszy = 0;

   ilosc_wierszy = sg->RowCount;

   for(ARow = 1; ARow < ilosc_wierszy; ARow++)
   {
   	sg->Cells[ACol][ARow] = IntToStr(ARow);
   }
   sg->Refresh();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::sgSelectCell(TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
	GSelected = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DrawRectGrid(TRect &Rect)
{
	if(GSelected)
   {
		sg->Repaint();
      GSelected = false;
   }

   sg->Canvas->Brush->Style = bsClear;
   sg->Canvas->Pen->Color   = clBlack;
   sg->Canvas->Pen->Width   = 2;
   sg->Canvas->Rectangle(Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::sgDrawCell(TObject *Sender, int ACol, int ARow, TRect &Rect, TGridDrawState State)
{
	bool       inny_kolor = false;
   AnsiString txt        = "";
	int        x          = 0;
	int        y          = 0;

	if(ARow == 0 || ACol == 0)
   {
		return;
   }

   // co drugi rzd w innym kolorze
	inny_kolor = fmod(ARow, 2);

	if(State.Contains(gdFocused))
   {
		DrawRectGrid(Rect);
   }

   if (inny_kolor)
   {
	   if(!State.Contains(gdFocused))
      {
      	txt = sg->Cells[ACol][ARow];

			// kolor niestandardowy
         sg->Canvas->Brush->Color = (TColor) 0x00D6EAEF;

         sg->Canvas->FillRect(Rect);

         x = Rect.Left + 2;
         y = (Rect.Top + Rect.Bottom - sg->Canvas->TextHeight(txt)) / 2;
         sg->Canvas->TextOutA(x, y, txt);
      }
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::sgGetEditMask(TObject *Sender, int ACol, int ARow, AnsiString &Value)
{
	/*
   Uwaga:
   wymagane aby bya aktywna opcja goEditing
   */

	if (ACol == colKodp)
   {
 		Value = "99-999";
	}

	if (ACol == colTel)
   {
		// Value := '000-00-00';
		Value = "(999) 000 00 00;1";
	   // Value =  '!\(999\00 00 00;1';
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::sgGetEditText(TObject *Sender, int ACol, int ARow, AnsiString &Value)
{
	if (ACol == colMiasto)
   {
		Value = AnsiUpperCase(Value);
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::GetRec(int ARow, MRek &Rek)
{
   Rek.Lp       = sg->Cells[colLp      ][ARow];
   Rek.Nazwisko = sg->Cells[colNazwisko][ARow];
   Rek.Imie     = sg->Cells[colImie    ][ARow];
   Rek.Ulica    = sg->Cells[colUlica   ][ARow];
   Rek.Kodp     = sg->Cells[colKodp    ][ARow];
   Rek.Miasto   = sg->Cells[colMiasto  ][ARow];
   Rek.Dataur   = sg->Cells[colDataur  ][ARow];
   Rek.Pesel    = sg->Cells[colPesel   ][ARow];
   Rek.Tel      = sg->Cells[colTel     ][ARow];
   Rek.Email    = sg->Cells[colEmail   ][ARow];
   Rek.Woj      = sg->Cells[colWoj     ][ARow];
   Rek.Zarobek  = sg->Cells[colZarobek ][ARow];
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SetRec(int ARow, MRek &Rek)
{
   sg->Cells[colLp      ][ARow] = Rek.Lp;
   sg->Cells[colNazwisko][ARow] = Rek.Nazwisko;
   sg->Cells[colImie    ][ARow] = Rek.Imie;
   sg->Cells[colUlica   ][ARow] = Rek.Ulica;
   sg->Cells[colKodp    ][ARow] = Rek.Kodp;
   sg->Cells[colMiasto  ][ARow] = Rek.Miasto;
   sg->Cells[colDataur  ][ARow] = Rek.Dataur;
   sg->Cells[colPesel   ][ARow] = Rek.Pesel;
   sg->Cells[colTel     ][ARow] = Rek.Tel;
   sg->Cells[colEmail   ][ARow] = Rek.Email;
   sg->Cells[colWoj     ][ARow] = Rek.Woj;
   sg->Cells[colZarobek ][ARow] = Rek.Zarobek;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::imbBABELKOWEClick(TObject *Sender)
{
	TTime t1, t2, t3;

	lblINFO->Visible = true;

   t1 = Time();
	lblINFO->Refresh();

   BabelSort();

   t2 = Time();
   t3 = t2 - t1;

	lblINFO->Visible = false;

	lblCZAS->Caption = "Czas trwania sortowania metod bbelkow: " + TimeToStr(t3);
	lblCZAS->Visible = true;   
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BabelSort(void)
{
	int AHigh = sg->RowCount-1;
   
	int J = 0;
	int I = 0;

   MRek ten;
   MRek pop;
   MRek nast;
   MRek temp;

	for(I = AHigh; I >= 1; I--)
   {
   	for(J = 1; J <= AHigh-1; J++)
      {
         GetRec(J, ten);
         GetRec(J+1, nast);

      	if(StrToInt(ten.Nazwisko) > StrToInt(nast.Nazwisko))
         {
         	GetRec(J, temp);

            SetRec(J, nast);
            SetRec(J+1, ten);
         }
      }
   }
}
//---------------------------------------------------------------------------

